﻿using System;
using System.Text.RegularExpressions;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace AADB_Base_Creator {
    /// <summary>
    /// Логика взаимодействия для Window_Base_Name.xaml
    /// </summary>
    public partial class EnterTheName : Window
    {
        static String _returnValue = "";
        static String _configuration = "";
        public EnterTheName(String label)
        {
            WindowStartupLocation = System.Windows.WindowStartupLocation.CenterScreen;
            InitializeComponent();

            MainLabel.Content = label;
        }

        public EnterTheName(String label, String oldName)
        {
            WindowStartupLocation = System.Windows.WindowStartupLocation.CenterScreen;
            InitializeComponent();

            MainLabel.Content = label;
            InputTextBox.Text = oldName;
        }

        public EnterTheName(String label, String suggestion, String configuration)
        {
            WindowStartupLocation = System.Windows.WindowStartupLocation.CenterScreen;
            _configuration = configuration;
            InitializeComponent();

            MainLabel.Content = label;
            InputTextBox.Text = suggestion;
            
        }



        private void Button_OK_Basename_Click(object sender, RoutedEventArgs e)
        {
            _returnValue = InputTextBox.Text;
            this.DialogResult = true;
            Close();

            //Options.ActiveForm.Close();
        }

        public string ReturnValue()
        {
            //_returnValue = TextBox_Basename.Text;
            return _returnValue;
        }

        private void TextBox_Basename_TextChanged(object sender, TextChangedEventArgs e)
        {
            var index = InputTextBox.CaretIndex;
            String temp = InputTextBox.Text;
            if (_configuration == "Device" || _configuration == "Copy")
            {
                temp = temp.Replace("?", "_");
                temp = temp.Replace("\"", "_");
                temp = temp.Replace("'", "_");
                temp = temp.Replace("|", "_");
            }
            else
            {
                temp = temp.Replace(" ", "_");
                temp = temp.Replace(".", "_");
                temp = temp.Replace("-", "_");
                temp = temp.Replace("+", "_");
                temp = temp.Replace("=", "_");
                temp = temp.Replace("!", "_");
                temp = temp.Replace("@", "_");
                temp = temp.Replace("(", "_");
                temp = temp.Replace(")", "_");
                temp = temp.Replace("^", "_");
                temp = temp.Replace("{", "_");
                temp = temp.Replace("}", "_");
                temp = temp.Replace("[", "_");
                temp = temp.Replace("]", "_");
                temp = temp.Replace("`", "_");
                temp = temp.Replace("~", "_");
                //Борис
                temp = temp.Replace("#", "_");
                temp = temp.Replace("$", "_");
                temp = temp.Replace("%", "_");
                temp = temp.Replace("&", "_");
                temp = temp.Replace("*", "_");
                temp = temp.Replace("<", "_");
                temp = temp.Replace(">", "_");
                temp = temp.Replace("|", "_");
                temp = temp.Replace("/", "_");
                temp = temp.Replace(":", "_");
                temp = temp.Replace("\\", "_");
                temp = temp.Replace("\"", "_");
                temp = temp.Replace("'", "_");
            }
            

            InputTextBox.Text = temp;
            InputTextBox.CaretIndex = index;
        }

        private void TextBox_Basename_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (_configuration != "Copy")
            {
                if (e.Key == Key.Space)
                    e.Handled = true;
            }

        }

        private static bool IsTextAllowed(string text)
        {
           Regex regex = new Regex("[^0-9a-zA-Z_.]"); //regex that matches disallowed text
            
            return !regex.IsMatch(text);
        }

        private void TextBox_Basename_PreviewTextInput(object sender, TextCompositionEventArgs e)
        {
           // e.Handled = !IsTextAllowed(e.Text);
        }
        
    }
}
